/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua.errorinfo;

import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.Prototype;

final class DebugHelpers {
    private DebugHelpers() {
    }

    private static int filterPc(int pc, int jumpTarget) {
        return pc < jumpTarget ? -1 : pc;
    }

    static int findSetReg(Prototype pt, int lastPc, int reg) {
        int lastInsn = -1;
        int jumpTarget = 0;
        block6: for (int pc = 0; pc < lastPc; ++pc) {
            int i = pt.code[pc];
            int op = Lua.GET_OPCODE((int)i);
            int a = Lua.GETARG_A((int)i);
            switch (op) {
                case 4: {
                    int b = Lua.GETARG_B((int)i);
                    if (a > reg || reg > a + b) continue block6;
                    lastInsn = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 34: {
                    if (a < a + 2) continue block6;
                    lastInsn = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 29: 
                case 30: {
                    if (reg < a) continue block6;
                    lastInsn = DebugHelpers.filterPc(pc, jumpTarget);
                    continue block6;
                }
                case 23: {
                    int dest = pc + 1 + Lua.GETARG_sBx((int)i);
                    if (pc >= dest || dest > lastPc || dest <= jumpTarget) continue block6;
                    jumpTarget = dest;
                    continue block6;
                }
                default: {
                    if (!Lua.testAMode((int)op) || reg != a) continue block6;
                    lastInsn = DebugHelpers.filterPc(pc, jumpTarget);
                }
            }
        }
        return lastInsn;
    }
}

