/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class SpeakerBlockEntity
extends BlockEntity {
    private final SpeakerPeripheral peripheral = new Peripheral(this);

    public SpeakerBlockEntity(BlockEntityType<SpeakerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void serverTick() {
        this.peripheral.update();
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && !this.level.isClientSide) {
            ServerNetworking.sendToAllPlayers(new SpeakerStopClientMessage(this.peripheral.getSource()), Nullability.assertNonNull(this.getLevel().getServer()));
        }
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    private static final class Peripheral
    extends SpeakerPeripheral {
        private final SpeakerBlockEntity speaker;

        private Peripheral(SpeakerBlockEntity speaker) {
            this.speaker = speaker;
        }

        @Override
        protected ServerLevel getLevel() {
            return (ServerLevel)this.speaker.getLevel();
        }

        @Override
        protected SpeakerPosition getPosition() {
            return SpeakerPosition.of(this.speaker.getLevel(), Vec3.atCenterOf((Vec3i)this.speaker.getBlockPos()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral o = (Peripheral)other;
            if (this.speaker != o.speaker) return false;
            return true;
        }
    }
}

